import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../../util/processResponse.js";
import { processOrderHistory } from "./processOrderHistory.js";

const initialState = {
    myOrders: [],
    loading: false,
    isRefresh: false,
    nextPageUrl: "",
    loadMore: false,
    pagination: {},
};

export const getMyOrders = createAsyncThunk(
    "user/getMyOrders",
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const res = await queryResponse(URL, "GET", access_token);
        return res;
    }
);

export const getMoreOrders = createAsyncThunk(
    "user/getMoreOrders",
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const res = await queryResponse(URL, "GET", access_token);
        return res;
    }
);

const getMyOrdersSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetOrderHistory: (state) => {
            state.myOrders = [];
            state.loading = false;
            state.isRefresh = false;
            state.pagination = {};
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getMyOrders.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getMyOrders.fulfilled, (state, { payload }) => {
            const {
                status: { code } = {},
                records: { pagination, data } = {},
            } = payload || {};
            if (code === 200) {
                const newData = processOrderHistory(data);
                state.myOrders = newData;
                state.nextPageUrl = pagination?.next_page_url;
                state.pagination = pagination;
            } else {
                state.myOrders = state.myOrders;
                state.pagination = state.pagination;
            }
            state.loading = false;
        });
        builder.addCase(getMyOrders.rejected, (state) => {
            state.loading = false;
        });
        builder.addCase(getMoreOrders.pending, (state) => {
            state.loadMore = true;
        });
        builder.addCase(getMoreOrders.fulfilled, (state, { payload }) => {
            const {
                status: { code } = {},
                records: { pagination, data } = {},
            } = payload || {};
            if (code === 200) {
                const newData = processOrderHistory(data);
                state.myOrders = [...state.myOrders, ...newData];
                state.nextPageUrl = pagination?.next_page_url;
                state.pagination = pagination;
            }
            state.loadMore = false;
        });
        builder.addCase(getMoreOrders.rejected, (state) => {
            state.loadMore = false;
        });
    },
});

export const { resetOrderHistory } = getMyOrdersSlice.actions;

export default getMyOrdersSlice.reducer;
